@extends('layouts.app')
<style>
    .select2 {
        width: 189px !important;


    }
</style>
@section('content')
    <div class="dashboard-wrapper">
        <div class="top-bar clearfix">
            <div class="row gutter">
                <div class="col-lg-6 col-md-6 col-sm-6 col-xs-12">
                    <div class="page-title">
                        <h4>{{ __('xcustomer::customer.headings.all_customer_list') }}</h4>
                    </div>
                </div>
                <div class="col-lg-6 col-md-6 col-sm-6 col-xs-12">
                    @can('ADD_CUSTOMER')
                        <ul class="right-stats" id="mini-nav-right">
                            <a href="{{ url('customer/create') }}"
                               class="btn btn-gradient-primary waves-effect waves-light float-right mb-3"><i
                                    class="fa fa-plus"
                                    aria-hidden="true"></i>
                                {{ __('xcustomer::customer.buttons.new_customer') }}</a>
                        </ul>
                    @endcan
                </div>
            </div>
        </div>

        <div class="main-container">
            <div class="row gutter">
                <div class="col-lg-12 col-md-12 col-sm-12 col-xs-12">
                    <div class="card">
                        <div class="card-body">
                            <form class="form-inline" action="{{ route('customer.index') }}">

                                <div class="form-group">
                                    <label for="">{{ __('xcustomer::customer.labels.business_name') }}</label> <br>
                                    <input type="text" name="business_name" value="{{request('business_name')}}" class="form-control" id="searchbusinessname"
                                           placeholder="{{ __('xcustomer::customer.labels.business_name') }}">
                                </div>
                                <div class="form-group">
                                    <label for="">{{ __('xcustomer::customer.labels.full_name') }}</label> <br>
                                    <input type="text" name="company_name" value="{{request('company_name')}}" class="form-control" id="searchfullname"
                                           placeholder="{{ __('xcustomer::customer.labels.full_name') }}">
                                </div>
                                <div class="form-group">
                                    <label for="">{{ __('xcustomer::customer.labels.mobile') }}</label> <br>
                                    <input type="text" name="mobile" value="{{request('mobile')}}" class="form-control" id="searchmobile"
                                           placeholder="{{ __('xcustomer::customer.labels.mobile') }}">
                                </div>
                                <div class="form-group">
                                    <label for="">{{ __('xcustomer::customer.labels.telephone') }}</label> <br>
                                    <input type="text" name="telephone" value="{{request('telephone')}}" class="form-control" id="searchtelephone"
                                           placeholder="{{ __('xcustomer::customer.labels.telephone') }}">
                                </div>
                                <div class="form-group">
                                    <label for="">{{ __('xcustomer::customer.labels.email') }}</label> <br>
                                    <input type="text" name="email" value="{{request('email')}}" class="form-control" id="searchemail"
                                           placeholder="{{ __('xcustomer::customer.labels.email') }}">
                                </div>
                                <div class="form-group">
                                    <div style="margin-top: 10px;">

                                        <label for="" >{{ __('xcustomer::customer.labels.nic') }}</label> <br>
                                        <input type="text"  name="nic" value="{{request('nic')}}" class="form-control" id="searchnic"
                                               placeholder="{{ __('xcustomer::customer.labels.nic') }}">
                                    </div>
                                </div>
                                {{-- @php
                                    $cities = \Pramix\XGeneral\Models\CityModel::get();
                                @endphp
                                <div class="form-group">
                                    <label for="">Select City</label> <br>
                                    {{-- {{ formDropdown('', 'customer_city', \Pramix\XGeneral\Models\CityModel::pluck('name_en', 'id'), '', ['class' => '', 'id' => 'customer_city']) }} --}}
                                    {{-- <select name="customer_city" id="customer_city" class="form-control select2 select3">
                                        <option value="">Select city</option>
                                        @foreach ($cities as $city )
                                        <option value="{{$city->id}}">{{$city->name_en}}</option>
                                        @endforeach
                                    </select>
                                </div> --}}

                                <div class="form-group">

                                    <label for="">Select Rep</label> <br>

                                    <select name="rep_id" id="rep" class="form-control select2 select3">
                                        <option value="">Select Rep</option>
                                        @foreach($roles as $role)
                                        <option value="{{ $role->id }}" @if(request('rep_id') == $role->id) selected @endif>{{ $role->username }} - {{$role ->fname }}  </option>
                                        @endforeach
                                    </select>

                                </div>

                                <div class="form-group">
                                    <label for="">Select Grade</label> <br>
                                    <select name="customer_grade" id="grade" class="form-control select2 select3">
                                        <option value="">Please Select</option>
                                        <option value="A" @if(request('customer_grade') == 'A') selected @endif>A</option>
                                        <option value="B" @if(request('customer_grade') == 'B') selected @endif>B</option>
                                        <option value="C" @if(request('customer_grade') == 'C') selected @endif>C</option>
                                        <option value="D" @if(request('customer_grade') == 'D') selected @endif>D</option>
                                    </select>
                                </div>

                                <div class="form-group">
                                    <br>&nbsp;&nbsp;<button type="submit" style="margin-top: 10px;" class="btn btn-gradient-primary waves-effect waves-light float-right mb-3">Submit</button>
                                </div>
                                <div class="form-group">
                                    <br>&nbsp;&nbsp; <a href="{{ route('customer.index') }}" style="margin-top: 10px;" class="btn btn-gradient-primary waves-effect waves-light float-right mb-3">Reset</a>
                                </div>
                            </form>
                        </div>
                    </div>

                    <div class="table-responsive">
                        <table id="customerListTable" class="table table-striped table-bordered no-margin"
                               cellspacing="0"
                               width="100%">
                            <thead>
                            {{-- <tr>
                                <th></th>
                                <th>{{ __('xcustomer::customer.labels.business_name') }}</th>
                                <th>{{ __('xcustomer::customer.labels.full_name') }}</th>
                                <th>{{ __('xcustomer::customer.labels.mobile') }}</th>
                                <th>{{ __('xcustomer::customer.labels.telephone') }}</th>
                                <th>{{ __('xcustomer::customer.labels.email') }}</th>
                                <th>{{ __('xcustomer::customer.labels.nic') }}</th>
                                <th>Area</th>
                                <th>Rep</th>
                                <th>{{ __('xcustomer::customer.labels.customer_grade') }}</th>
                                <th>{{ __('xcustomer::customer.labels.outstanding_amount') }}</th>
                                <th>{{ __('xcustomer::customer.labels.action') }}</th>
                            </tr> --}}
                            <tr>
                                <th>CUSTOMER CODE</th>
                                <th>FULLNAME</th>
                                <th>MOBILE</th>
                                <th>AREA</th>
                                <th>REP</th>
                                <th>GRADE</th>
                                <th>OUTSTANDING AMOUNT</th>
                                <th>ACTION</th>
                            </tr>
                            </thead>
                            <tbody>
                                @foreach ($customers as $customer)
                                <tr>
                                    <td>{{$customer->business_name}}</td>
                                    <td> <b>{{$customer->company_name}}</b> </td>
                                    <td>{{$customer->mobile}}</td>
                                    <td>{{$customer->customerPrivateAddress->city->name_en ?? ''}}</td>
                                    <td>{{$customer->rep->username}}</td>
                                    <td>{{$customer->customer_grade}}</td>
                                    @php
                                         $outstanding_amount = App\Utils\CommonUtil::calculateCustomerInvoiceOutstanding($customer->id);
                                    @endphp
                                    <td>{{ App\Http\Helper::formatPrice($outstanding_amount) }}</td>
                                    @php
                                        $delete_customer_permission = Illuminate\Support\Facades\Auth::user()->can(['DELETE_CUSTOMER']);
                                        $block_customer_permission = Illuminate\Support\Facades\Auth::user()->can(['BLOCK_CUSTOMER']);
                                        $files_customer_permission = Illuminate\Support\Facades\Auth::user()->can(['SHOW_ATTECH_FILES']);
                                        $edit_customer_permission = false;
                                        if(Illuminate\Support\Facades\Auth::user()->can('EDIT_CUSTOMER')) {
                                            $edit_customer_permission = true;
                                        }

                                    @endphp
                                    <td>
                                        @if ($files_customer_permission)
                                            <a class="btn btn-success btn-xs" href="{{ route('file-attech', $customer->id) }}" data-original-title="" title=""><i class="fa fa-file"></i></a>
                                        @endif

                                        @if ($block_customer_permission)
                                            @php
                                                $text = 'fa-ban';
                                                $class = 'block-customer';
                                                if ($customer->block_status == 'Blocked') {
                                                    $text = 'fa-check';
                                                    $class = 'unblock-customer';
                                                }
                                            @endphp
                                            <a class="btn btn-warning btn-xs {{ $class }}" href="javascript:void(0)" data-id="{{ $customer->id }}" data-original-title="" title=""><i class="fa {{ $text }}"></i></a>
                                        @endif

                                        @if ($edit_customer_permission)
                                            <a class="btn btn-info btn-xs" href="{{ url('/customer/' . $customer->id . '/edit') }}" id="edit_customer" data-original-title="" title=""><i class="fa fa-pencil"></i></a>
                                            <button class="btn btn-primary btn-xs" id="customer_history"><i class="fa fa-history" aria-hidden="true"></i></button>
                                        @endif

                                        @if ($delete_customer_permission)
                                            &nbsp;<button class="delete_customer btn btn-danger btn-xs" data-toggle="tooltip" data-placement="right" title="" data-original-title="Delete " aria-describedby="tooltip934027"><i class="fa fa-trash-o" aria-hidden="true"></i></button>
                                        @endif
                                    </td>
                                </tr>
                                @endforeach
                            </tbody>
                        </table>
                        <div class="d-flex justify-content-end">
                            {{ $customers->appends($_GET)->links() }}
                        </div>
                    </div>
                </div>
            </div>
            <!-- Row ends -->

        </div>
        <!-- Main container ends -->

{{--        Block Model--}}
        <div class="modal fade" id="block-modal" tabindex="-1" aria-labelledby="block-modal-label" aria-hidden="true">
                @csrf
                <div class="modal-dialog">
                    <div class="modal-content append-body">

                    </div>
                </div>
        </div>

    </div>
    <!-- Dashboard wrapper ends -->
@endsection

@section('include_js')
@endsection

@section('custom_script')
    <script>

        $(document).ready(function () {
            $(document).on('click', '.block-customer', function(e){
                e.preventDefault(); // prevent default link behavior
                let id = $(this).data('id');
                let url = '{{ route('block.open.modal', ':id') }}';
                url = url.replace(':id', id);

                // send AJAX request to load the modal content
                $.get(url, function (data) {

                    // // add the modal content to the page
                    $('.append-body').empty();
                    $('.append-body').append(data);
                    //
                    // // show the modal
                    $('#block-modal').modal('show');
                });
            })

            $(document).on('click', '#close-modal', function() {
                $('#block-modal').modal('hide');
            });

            $(document).on('submit', '#block-form', function (e) {
                e.preventDefault(); // prevent default link behavior
                let form = $(this).serialize();
                let action = $(this).attr('action');;
                $.ajax({
                    method: 'POST',
                    url: action,
                    data: form,
                    success: function (response) {
                        notification(response);
                        $('#block-modal').modal('hide');
                        customer_list_table.draw();
                    }
                })
            })

            $(document).on('click', '.unblock-customer', function (e) {
                e.preventDefault(); // prevent default link behavior
                let id = $(this).data('id');
                let url = '{{ route('unblock.customer', ':id') }}';
                url = url.replace(':id', id);
                $.ajax({
                    method: 'GET',
                    url: url,
                    success: function (response) {
                        notification(response);
                        customer_list_table.draw();
                    }
                })
            })

            // var customer_list_table = $('#customerListTable').DataTable({
            //     // dom: 'Blfrtip',
            //     lengthMenu: [
            //         [25, 50, 100, -1],
            //         ['25 ', '50 ', '100', 'All']
            //     ],
            //     processing: true,
            //     serverSide: true,
            //     "order": [
            //         [0, 'desc']
            //     ],
            //     'iDisplayLength': 15,
            //     ajax: '{!! route('get.all_customers') !!}',
            //     columns: [{
            //         data: 'id',
            //         name: 'id',
            //         'bVisible': false
            //     },
            //         {
            //             data: 'business_name',
            //             name: 'business_name'
            //         },
            //         {
            //             data: 'fullname',
            //             name: 'fullname'
            //         },
            //         {
            //             data: 'mobile',
            //             name: 'mobile'
            //         },
            //         {
            //             data: 'telephone',
            //             name: 'telephone',
            //             'bVisible': false
            //         },
            //         {
            //             data: 'email',
            //             name: 'email',
            //             'bVisible': false
            //         },
            //         {
            //             data: 'nic',
            //             name: 'nic',
            //             'bVisible': false
            //         },
            //         {
            //             data: 'city',
            //             name: 'city'
            //         },
            //         {
            //             data: 'rep',
            //             name: 'rep'
            //         },
            //         {
            //             data: 'customer_grade',
            //             name: 'customer_grade'
            //         },
            //         {
            //             data: 'outstanding_amount',
            //             name: 'outstanding_amount',
            //             className: 'dt-body-right'
            //         },
            //         {
            //             data: 'action',
            //             name: 'action'
            //         },
            //     ]
            // });

            $('#searchbusinessname').on('keyup', function () {
                customer_list_table.column(1)
                    .search(this.value)
                    .draw();
            });
            $('#searchfullname').on('keyup', function () {
                customer_list_table.column(2)
                    .search(this.value)
                    .draw();
            });
            $('#searchmobile').on('keyup', function () {
                customer_list_table.column(3)
                    .search(this.value)
                    .draw();
            });
            $('#searchtelephone').on('keyup', function () {
                customer_list_table.column(4)
                    .search(this.value)
                    .draw();
            });
            $('#searchemail').on('keyup', function () {
                customer_list_table.column(5)
                    .search(this.value)
                    .draw();
            });

            $('#searchnic').on('keyup', function () {
                customer_list_table.column(6)
                    .search(this.value)
                    .draw();
            });

            $('#searchaccountno').on('keyup', function () {
                customer_list_table.column(7)
                    .search(this.value)
                    .draw();
            });


            var select_city = new Option('Select city', '', true, true);
            $('#customer_city').append(select_city).trigger('change');

            var select_rep = new Option('Select Rep', '', true, true);
            $('#rep').append(select_rep).trigger('change');

            $('#customer_city').on('change', function () {
                if ($('#customer_city').val() != '') {
                    customer_list_table.column(7)
                        .search($('#customer_city option:selected').text())
                        .draw();
                } else {
                    customer_list_table.column(7)
                        .search('')
                        .draw();
                }
            });
            $('#rep').on('change', function () {

                if ($('#rep').val() != '') {
                    let selectedOption = $('#rep option:selected').text();
                    let searchText = selectedOption.split('-')[0].trim();
                    customer_list_table.column(8)
                        // .search($('#rep option:selected').text())
                        .search(searchText)
                        .draw();
                } else {
                    customer_list_table.column(8)
                        .search('')
                        .draw();
                }
            });
            $('#grade').on('change', function () {
                if ($('#grade').val() != 'all') {
                    customer_list_table.column(9)
                        .search($('#grade option:selected').text())
                        .draw();
                } else {
                    customer_list_table.column(9)
                        .search('')
                        .draw();
                }
            });


            $('body').on('click', '#customer_history', function () {
                var data = customer_list_table.row($(this).parents('tr')).data();
                window.customer_history_model = $.confirm({
                    title: 'Customer History',
                    draggable: true,
                    boxWidth: '80%',
                    closeIcon: true,
                    useBootstrap: false,
                    buttons: {
                        close: function () {
                        }
                    },
                    content: 'url:' + BASE + 'customer_invoices/customer_history_modal/' + data[
                        'id'],
                    onContentReady: function () {

                    },
                    columnClass: 'medium',
                });
                return false;
            });


            $('#customerListTable tbody').on('click', 'button.customer_outstanding_button', function (e) {
                var $btn = $(this);
                $btn.button('loading');

                var data = customer_list_table.row($(this).parents('tr')).data();

                var params = {

                    customer_id: data['id']
                };
                var params = {

                    customer_id: data['id']
                };

                $.ajax({
                    url: BASE + 'reports/generate_customer_outstanding_report',
                    type: 'POST',
                    dataType: 'JSON',
                    data: $.param(params),
                    success: function (response) {
                        if (response.status == 'success') {
                            window.open(response.report_url);
                            $btn.button('reset');

                        } else {
                            notification(response);
                            $btn.button('reset');
                            return false;
                        }
                    },
                    error: function (xhr, ajaxOptions, thrownError) {

                        notificationError(xhr, ajaxOptions, thrownError);
                    }
                });

                return false;
            });


            $(document).on('click', '.delete_customer', function (e) {
                var data = customer_list_table.row($(this).parents('tr')).data();
                var parent = $(this).parents('tr');

                var delete_confirm = $.confirm({
                    title: "Delete Customer",
                    type: 'red',
                    buttons: {
                        delete: {
                            text: 'Delete',
                            btnClass: 'btn-red',
                            action: function () {

                                e.preventDefault();
                                var params = {};

                                $.ajax({
                                    url: BASE + 'customer/' + data['id'],
                                    type: 'DELETE',
                                    dataType: 'JSON',
                                    data: $.param(params),
                                    success: function (response) {
                                        if (response.status == 'error') {
                                            delete_confirm.close();
                                            notification(response);
                                        } else {

                                            delete_confirm.close();

                                            notification(response);

                                            customer_list_table
                                                .row(parent)
                                                .remove()
                                                .draw();

                                        }
                                    },
                                    error: function (errors) {

                                    }
                                });
                                e.preventDefault();
                                return false;
                            }
                        },
                        close: function () {
                        }
                    }
                });
            });

            $("#genarate_excel").on('click', function () {
                let rep = $('#rep').val();
                let city = $('#city').val();
                let grade = $('#grade').val();
                var params = {

                    grade: grade,
                    city: city,
                    rep: rep,


                };
                $.ajax({
                    url: BASE + 'customer/excel-generate',
                    type: 'POST',
                    dataType: 'JSON',
                    data: $.param(params),
                    success: function (response) {

                    },

                });

            });


        });
    </script>
@endsection
